<?php

$config = include_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../stripe/vendor/autoload.php';

$key = $config['stripe_key'];

if (!$key) {
    die("Stripe configuration error: Unable to retrieve secret key.");
}

\Stripe\Stripe::setApiKey($key); 



try {
    $connectionToken = \Stripe\Terminal\ConnectionToken::create();
    echo json_encode($connectionToken);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
