<?php


$config = include_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../stripe/vendor/autoload.php';



$key = $config['stripe_key'];

if (!$key) {
    die("Stripe configuration error: Unable to retrieve secret key.");
}


\Stripe\Stripe::setApiKey($key); 


$amount = isset($_GET['amount']) ? intval($_GET['amount']) : 1000;
$currency = isset($_GET['currency']) ? $_GET['currency'] : 'usd';

$intent = \Stripe\PaymentIntent::create([
  'amount' => $amount,
  'currency' => $currency,
  'payment_method_types' => ['card_present'],
  'capture_method' => 'automatic',
]);

echo json_encode([
  'client_secret' => $intent->client_secret
]);