<?php
// box/api/customers.php

// Enable error reporting for debugging
//ini_set('display_errors', 1);
//error_reporting(E_ALL);

// Clear any potential output buffers

while (ob_get_level()) {
    ob_end_clean();
}

header('Content-Type: application/json');



//file_put_contents('customers_debug.log', "Step 2: getTopDir worked: $topDir\n", FILE_APPEND);

// Load config - matching products.php structure
$config = include __DIR__ . '/../config/config.php';

//file_put_contents('customers_debug.log', "Step 3: Config loaded: " . (is_array($config) ? 'YES' : 'NO') . "\n", FILE_APPEND);
//file_put_contents('customers_debug.log', "Database name: " . ($config['db_name'] ?? 'NOT SET') . "\n", FILE_APPEND);

// Database connection
$conn = new mysqli(
    $config['db_host'],
    $config['db_user'],
    $config['db_pass'],
    $config['db_name']
);

//file_put_contents('customers_debug.log', "Step 4: Database connection attempted\n", FILE_APPEND);

// Check connection
if ($conn->connect_error) {
    file_put_contents('customers_debug.log', "Step 4 ERROR: " . $conn->connect_error . "\n", FILE_APPEND);
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

//file_put_contents('customers_debug.log', "Step 5: Database connected successfully\n", FILE_APPEND);

// Configuration
$max_customers = 1000;

// Check which database we're in
$is_ncetickets = (strpos(strtolower($config['db_name']), 'ncetickets') !== false);
file_put_contents('customers_debug.log', "Step 6: Database type - " . ($is_ncetickets ? 'NCETickets' : 'osConcert') . "\n", FILE_APPEND);

if ($is_ncetickets) {
    // NCETickets database - simple users table
    $sql = "SELECT id, name, email FROM users WHERE email IS NOT NULL AND email != '' AND name IS NOT NULL AND name != '' ORDER BY id DESC LIMIT ?";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        file_put_contents('customers_debug.log', "Query prep failed: " . $conn->error . "\n", FILE_APPEND);
        echo json_encode(['error' => 'Query preparation failed', 'details' => $conn->error]);
        exit;
    }
    $stmt->bind_param("i", $max_customers);
} else {
    // osConcert database - customers table
    $sql = "SELECT customers_id as id, CONCAT(IFNULL(customers_firstname, ''), ' ', IFNULL(customers_lastname, '')) as name, customers_email_address as email FROM customers WHERE customers_email_address IS NOT NULL AND customers_email_address != '' ORDER BY customers_id DESC LIMIT ?";
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        file_put_contents('customers_debug.log', "Query prep failed: " . $conn->error . "\n", FILE_APPEND);
        echo json_encode(['error' => 'Query preparation failed', 'details' => $conn->error]);
        exit;
    }
    $stmt->bind_param("i", $max_customers);
}

//file_put_contents('customers_debug.log', "Step 7: Query prepared\n", FILE_APPEND);

$stmt->execute();
$result = $stmt->get_result();

//file_put_contents('customers_debug.log', "Step 8: Query executed, rows found: " . $result->num_rows . "\n", FILE_APPEND);

$customers = [];

while ($row = $result->fetch_assoc()) {
    // Clean UTF-8 encoding issues
    $name = $row['name'] ?? '';
    $email = $row['email'] ?? '';
    
    // Remove any non-UTF8 characters
    $name = mb_convert_encoding($name, 'UTF-8', 'UTF-8');
    $email = mb_convert_encoding($email, 'UTF-8', 'UTF-8');
    
    // Also try iconv as a fallback
    if (function_exists('iconv')) {
        $name = iconv('UTF-8', 'UTF-8//IGNORE', $name);
        $email = iconv('UTF-8', 'UTF-8//IGNORE', $email);
    }
    
    // Trim and clean
    $name = trim($name);
    if (empty($name) || $name === ' ') {
        $name = 'Customer ' . $row['id'];
    }
    
    $customers[] = [
        'id' => (int)$row['id'],
        'name' => $name,
        'email' => strtolower(trim($email))
    ];
}

//file_put_contents('customers_debug.log', "Step 9: Processed " . count($customers) . " customers\n", FILE_APPEND);

$stats = [
    'customer_count' => count($customers),
    'max_customers' => $max_customers,
    'database' => $config['db_name']
];

$response = [
    'customers' => $customers,
    'stats' => $stats
];

$stmt->close();
$conn->close();

// Test if JSON encoding works
$json_output = json_encode($response);
if ($json_output === false) {
    file_put_contents('customers_debug.log', "JSON encoding failed: " . json_last_error_msg() . "\n", FILE_APPEND);
    // Try to output a simple error
    echo '{"error":"JSON encoding failed: ' . json_last_error_msg() . '"}';
    exit;
}

//file_put_contents('customers_debug.log', "Step 10: JSON encoded successfully, length: " . strlen($json_output) . "\n", FILE_APPEND);

// Write first 500 chars to log to verify content
//file_put_contents('customers_debug.log', "First 500 chars of JSON: " . substr($json_output, 0, 500) . "\n", FILE_APPEND);

// Output the JSON
echo $json_output;

//file_put_contents('customers_debug.log', "Step 11: Complete!\n\n", FILE_APPEND);

// Make sure nothing else outputs
exit();
?>