<?php
// list_locations.php - Minor UTF-8 improvements

$config = include_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../stripe/vendor/autoload.php';
 
$key = $config['stripe_key'];

if (!$key) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => 'Stripe configuration error: Unable to retrieve secret key.']);
    exit;
}

\Stripe\Stripe::setApiKey($key);

try {
    $locations = \Stripe\Terminal\Location::all(['limit' => 100]);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode($locations, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}