<?php
// send_receipt.php
require_once __DIR__ . '/../email/email_lib_config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $to        = $_POST['email'] ?? '';
    $textBody  = $_POST['body'] ?? '';
    $htmlBody  = $_POST['html_body'] ?? null;
    $subject   = $_POST['subject'] ?? 'Your Receipt';
    
    // Clean UTF-8 on all inputs
    $to = mb_convert_encoding($to, 'UTF-8', 'UTF-8');
    $textBody = mb_convert_encoding($textBody, 'UTF-8', 'UTF-8');
    $subject = mb_convert_encoding($subject, 'UTF-8', 'UTF-8');
    if ($htmlBody !== null) {
        $htmlBody = mb_convert_encoding($htmlBody, 'UTF-8', 'UTF-8');
    }

    if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
        http_response_code(400);
        echo "Invalid email address.";
        exit;
    }

    // If html_body is provided, send HTML; otherwise keep text as-is
    if (!empty($htmlBody)) {
        $success = sendEmail($to, $subject, $htmlBody, /* isHTML */ true);
    } else {
        $success = sendEmail($to, $subject, $textBody, /* isHTML */ false);
    }

    if ($success === true) {
        echo "OK";
    } else {
        http_response_code(500);
        echo "Mail failed: " . $success; // Removed emoji to avoid encoding issues
    }
}