<?php
// email_config.php - Email configuration for osConcert integration
// Copy this file and customize for your osConcert installation

return [
    // Organization Details
    'organization_name' => 'MY Organization',
    'organization_email' => 'info@website.org',
    
    // SMTP Settings
    'smtp_enabled' => false,  // Set to false to use PHP mail() instead
    'smtp_host' => 'smtp.office365.com',  // Your SMTP server
    'smtp_port' => 587,  // Common ports: 587 (TLS), 465 (SSL), 25 (unsecured)
    'smtp_secure' => 'tls',  // 'tls', 'ssl', or '' for none
    'smtp_auth' => true,  // Usually true for authentication
    'smtp_user' => 'robertjansen@nationalchamberensemble.org',  // SMTP username
    'smtp_pass' => 'NCEorg1234!',  // SMTP password (use App Password for Email)
    
    // From Address Settings
    'smtp_from_email' => 'info@website.org',  // Email that appears in "From" field
    'smtp_from_name' => 'Concert Tickets',  // Name that appears in "From" field
    
    // Advanced Settings
    'smtp_timeout' => 30,  // Connection timeout in seconds
    'smtp_debug' => 0,  // Debug level: 0=off, 1=client, 2=server, 3=connection, 4=lowlevel
];

/* 
USAGE EXAMPLES:

// Basic email sending
require_once 'email_lib_config.php';
$result = sendEmail('user@example.com', 'Subject', 'Message body');

// With custom config file
$result = sendEmailConfig('user@example.com', 'Subject', 'Message', false, '/path/to/custom_config.php');

// HTML email
$result = sendEmail('user@example.com', 'Subject', '<h1>HTML Message</h1>', true);

// Advanced email with attachments, CC, etc.
$result = sendEmailAdvancedConfig('user@example.com', 'Subject', 'Message', [
    'isHTML' => true,
    'cc' => ['cc@example.com'],
    'bcc' => ['bcc@example.com'],
    'attachments' => ['/path/to/file.pdf'],
    'replyTo' => 'reply@example.com',
    'priority' => 1  // 1=High, 3=Normal, 5=Low
]);

// Check result
if ($result === true) {
    echo "Email sent successfully!";
} else {
    echo "Error: " . $result;
}
*/